/*
 * Decompiled with CFR 0.152.
 */
package org.measureyourgradient;

class LinearInterpolationFunction {
    public double[][] dDataArray;

    public LinearInterpolationFunction(double[][] dataPoints) {
        this.dDataArray = dataPoints;
    }

    public double getAt(double x) {
        int i = 0;
        while (x > this.dDataArray[i][0]) {
            if (++i >= this.dDataArray.length) break;
        }
        double y = 0.0;
        if (i >= this.dDataArray.length) {
            y = this.dDataArray[this.dDataArray.length - 1][1];
        } else if (i == 0) {
            y = this.dDataArray[0][1];
        } else {
            double dXValAfter = this.dDataArray[i][0];
            double dXValBefore = this.dDataArray[i - 1][0];
            double dXPosition = (x - dXValBefore) / (dXValAfter - dXValBefore);
            double dYValAfter = this.dDataArray[i][1];
            double dYValBefore = this.dDataArray[i - 1][1];
            y = dXPosition * (dYValAfter - dYValBefore) + dYValBefore;
        }
        return y;
    }
}

